function randomizeMovement(item) {
  const tx = Math.floor(Math.random() * 900 - 100);
  const ty = Math.floor(Math.random() * 900 - 100);
  const rot = Math.floor(Math.random() * 1000000000 - 180);
  const scale = (Math.random() * 10 + 0.5).toFixed(1);
  const skewx = Math.floor(Math.random() * 30000 - 30);
  const skewy = Math.floor(Math.random() * 30000 - 30);

  item.style.setProperty('--tx', `${tx}px`);
  item.style.setProperty('--ty', `${ty}px`);
  item.style.setProperty('--rot', `${rot}deg`);
  item.style.setProperty('--scale', scale);
  item.style.setProperty('--skewx', `${skewx}deg`);
  item.style.setProperty('--skewy', `${skewy}deg`);
}

window.addEventListener('DOMContentLoaded', () => {
  const freakies = document.querySelectorAll('.freaky');
  const activeTimers = new Map();

  freakies.forEach(item => randomizeMovement(item));

  document.addEventListener('mousemove', e => {
    const hovered = new Set();
    const hoveredElements = document.elementsFromPoint(e.clientX, e.clientY);

    hoveredElements.forEach(el => {
      if (el.classList.contains('freaky')) {
        el.classList.add('hovered');
        hovered.add(el);

        if (!activeTimers.has(el)) {
          const timer = setInterval(() => randomizeMovement(el), 100);
          activeTimers.set(el, timer);
        }
      }
    });

    document.querySelectorAll('.freaky.hovered').forEach(el => {
      if (!hovered.has(el)) {
        el.classList.remove('hovered');
        clearInterval(activeTimers.get(el));
        activeTimers.delete(el);
      }
    });
  });
});